let createSound = (url) => {
    var audio = new Audio(url);
    return audio;
};

var Sounds = {
    music: createSound('sounds/music.ogg'),
    click: createSound('sounds/click.wav'),
    keyboard: createSound('sounds/keyboard.wav'),
    keyboard2: createSound('sounds/keyboard.ogg'),
    gasp: createSound('sounds/gasp.wav'),
    mail: createSound('sounds/mail.wav'),
    stamp: createSound('sounds/stamp.wav'),
    money: createSound('sounds/money.wav'),
    softFail: createSound('sounds/soft-fail.wav'),
    toast: createSound('sounds/toast.wav'),
    selection: createSound('sounds/selection.wav'),
    produce: createSound('sounds/blop.wav'),
    victory: createSound('sounds/victory.wav'),
    percussionEchoNotification1: createSound('sounds/Percussion Echo Notification1.wav'),
    roboticServoNotifcation: createSound('sounds/Robotic Servo Notifcation.wav'),
    roboticServoNotifcation2: createSound('sounds/Robotic Servo Notifcation 2.wav'),
    roboticServoNotifcation3Bassy: createSound('sounds/Robotic Servo Notifcation 3 Bassy.wav'),
    messagePingX2: createSound('sounds/Message Ping X2.wav'),
    gameNotification80: createSound('sounds/Game Notification 80.wav')
};

function PlaySound(sound) {
    let newVolume = CalculateVolume(false);
    if (newVolume == null) newVolume = 0;

    sound.volume = parseFloat((newVolume / 100).toFixed(2));
    sound.currentTime = 0;
    sound.play();

    Helpers.ConsoleInfo('Played sound', sound);
}

function PlayLoop(sound, isMusic, playbackSpeed) {
    if(isMusic == null) isMusic = true;
    let newVolume = CalculateVolume(isMusic);
    if (newVolume == null) newVolume = 0;
    var correctedVolume = parseFloat((newVolume / 100).toFixed(2));
    sound.volume = correctedVolume;
    sound.playbackRate = playbackSpeed || 1;
    sound.loop = true;
    sound.play();
}

function PlayKeyboard(fastForward) {
    PlayLoop(Sounds.keyboard, false, fastForward ? 2 : 0.8);
    PlayLoop(Sounds.keyboard2, false, fastForward ? 2 : 0.8);
}

function PauseKeyboard() {
    Sounds.keyboard.pause();
    Sounds.keyboard2.pause();
}